#ifndef Structure_h
#define Structure_h
#include <iostream>
#include <string>
#include <ctime>

struct BAccount {
    int number;
    long code;
    std::string surname;
    double sum;
    std::string creationDate;
    double interest;
    
    BAccount(const BAccount& el): number(el.number), code(el.code), surname(el.surname), sum(el.sum), creationDate(el.creationDate), interest(el.interest){}
    
    BAccount(int number_,
             long code_,
             const std::string& surname_,
             double sum_,
             const std::string& creationDate_,
             double interest_): number(number_), code(code_), surname(surname_), sum(sum_), creationDate(creationDate_), interest(interest_){}
    
    BAccount() = default;
    
    friend std::ostream& operator<<(std::ostream& out, const BAccount& el){
        out << "Account #" << el.number << std::endl;
        out << "Code: " << el.code << std::endl;
        out << "Owner's surname: " << el.surname << std::endl;
        out << "Money: " << el.sum << "$" << std::endl;
        out << "Creation date: " << el.creationDate << std::endl;
        out << "Interest rate: " << el.interest << std::endl;
        return out;
    }
    
    friend std::istream& operator>>(std::istream& in, BAccount& el){
        std::cout << "_____Creating a new account_____" << std::endl;
        std::cout << "Enter account number:" << std::endl;
        in >> el.number;
        std::cout << "Enter account code:" << std::endl;
        in >> el.code;
        std::cout << "Enter owner's surname:" << std::endl;
        in >> el.surname;
        std::cout << "Enter quantity of money:" << std::endl;
        in >> el.sum;
        std::cout << "Enter creation date(dd/mm/yy):" << std::endl;
        in >> el.creationDate;
        std::cout << "Enter account interest rate(%/100):" << std::endl;
        in >> el.interest;
        return in;
    }
};

#endif
